%% DATI NUMERICI %% 

Text = 223.15;            %temperatura esterna di corciera a Mach5 in Kelvin Z25000m

Mach = 5 ;


Thrust_ramjet = 10;       %Ramjet thrust [kN]


M_vehicle_dry_noengine_MR5 = 0;
M_engineATR_dry_MR5 = 4000;           %ATR one engine kg
M_engineDMR_dry_MR5 = 1400;           %DMR one engine kg
M_engine_dry_MR5 = 4000+1400;         %ATR+DMR one engine kg
                   
n_subcontractors=5;                      %number of sub-contractors in the project
n_stage = 1;              %number of stages for the vehicle

f0= 1.04^n_stage;         %Systems engineering / integration factor(Development)           
f1= 0.3;                  %Development standard factor (from 0.3 for a variation of an existing project; to 1.4 for a new concept involving new techniques and technologies)
f2= Mach.^0.15;            %Technical quality factor
f3= 1.4;                  %Team experience factor(from 0.5 for extended experience; to 1.4 for new team with no experience)
f4= 0;                    %Learning curve factor
f6= 1;                    %Deviation from optimal schedule  (1 for on-time and up to 1.6 for heavy delays)
f7= n_subcontractors^0.2;                %Program organization factor
f8= 0.86;                 %Impact of region productivity (1 for USA, 0.86 for Europe, 1.2 for China, 1.5 to 2.1 for Russia)
f9= 0;                    %Impact of subcontractors
f10= 0;
f11= 0;                   %Reduction factor due to absence of government contracts
f0_new= 1.03;
f10_new= 0;               %Cost reduction factor
f11_new= 0;             

vel_sound= (1.4*287*Text)^0.5;                       %m/s

velocity_cruise= vel_sound.*Mach;                     %m/s
velocity_cruise_KMH = velocity_cruise*3.6;           %km/h


M_vehicle_dry_noengine = 200000;                         % dry mass of vehicle without engines kg
       

Moew = 130000;                      %kg


M_engineATR_dry = 4000;           %ATR one engine kg
M_engineDMR_dry = 1400;           %DMR one engine kg
M_engine_dry = 4000+1400;         %1ATR+1DMR one engine kg

C_complex= 1;
Ktj= 0.6;                             %low-speed configuration coefficients ranging from 0 to 1
Krj= 0.4;                             %high-speed configuration coefficients ranging from 0 to 1

K_TRL = 0.5 ;                          %factor accounting for the vehicle maturity (from 0 for an average TRL 1 to 1 for an average TRL of 9)

CPI_2023 = 240.01;                          %Consumer Price Index 2023?
CPI_2016 = 240.01;                          %Consumer Price Index reference (2016)

MYr_to_Milion_factor = 0.3102;

%Data PROD
n_engine_installed = 7;
n_MR5produced = 1;
Q = 100000;                 %Heat load [J/m2]    
n = 100;                      %number of vehicles (i.e. number of airframes) built
n_E = 100;                     %number of engines built
p = 0.88;                   %p is cost reduction percentage to be applied each time that the number of produced units doubles
iesimo = 13;                %iesimo item costruito

f4_n = n^((log(p))/(log(2)));   % n is the last
f4_iesimo = iesimo^((log(p))/(log(2)));  %iesimo

Moew_ton = Moew/1000;

velocity_cruise_engine = 200;   %maximum operative speed of the engine [m/s]


%% PROD RESEARCH V2 %MYr %System Level - Vehicle 

                                                                        %Transcost

                                        %Production (PROD) cost for high speed advanced aircraft [WYr]

%Fvf_originalTRANSCOST = (0.376*(Moew^0.747))*f4*n

%Fvf_originalRESEARCH = (0.357*(Moew^0.762))*fa_n

%Fvf_PROD = ((0.34*(Moew_ton^1.75))+(7.06*(velocity_cruise^0.4)))*f4_n;

Moew_variable = 0:4000:200000; 
Moew_ton_variable = 0:4:200; 
velocity_cruise_vehicle_kmh_variable = 0:400:20000;

figure(1)
Fvf_PROD = ((0.34.*((Moew_variable./1000).^1.75))+(7.06.*(velocity_cruise_vehicle_kmh_variable.^0.4)));
Fvf_originalTRANSCOST = (0.376.*(Moew_variable.^0.747));
loglog(Moew_variable,Fvf_PROD,'DisplayName','Polito CER')
hold on
loglog(Moew_variable,Fvf_originalTRANSCOST,'DisplayName','Original TRANSCOST CER')
hold on
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'F_V_F PROD Vehicle w/o engines cost ','[MYr]'})
legend show
grid on
f = figure(1);  
f.Position = [100 100 800 600]; 



velocity_cruise_vehicle_kmh_1 = [1000, 2000, 3000, 4000, 5000, 7500, 20000];
figure(2)
for k=1:length(velocity_cruise_vehicle_kmh_1)
    Fvf_mass_variable=((0.34.*(Moew_ton_variable.^1.75))+(7.06.*(velocity_cruise_vehicle_kmh_1(k).^0.4)));
    txt = ['Cruise speed = ',num2str(velocity_cruise_vehicle_kmh_1(k)),'[Km/h]'];
    plot(Moew_ton_variable,Fvf_mass_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[tons]'})
ylabel({'F_V_F PROD Vehicle w/o engines cost ','[MYr]'})
legend show
grid on
f = figure(2);  
f.Position = [100 100 800 600]; 


Moew_ton_1 = [50, 75, 100, 120, 150, 180, 200];
figure(3)
for k=1:length(Moew_ton_1)
   Fvf_velocity_cruise_variable=((0.34.*(Moew_ton_1(k).^1.75))+(7.06.*(velocity_cruise_vehicle_kmh_variable.^0.4)));
   txt = ['M_O_E_W = ',num2str(Moew_ton_1(k)),' [tons]'];
   plot(velocity_cruise_vehicle_kmh_variable,Fvf_velocity_cruise_variable,'DisplayName',txt)
   hold on
end
xlabel({'Cruise speed','[Km/h]'})
ylabel({'F_V_F PROD Vehicle w/o engines cost ','[MYr]'})
legend show
grid on
f = figure(3);  
f.Position = [100 100 800 600]; 



i=0:1:length(Moew_ton_variable);
j=0:1:length(velocity_cruise_vehicle_kmh_variable);
for i=1:length(Moew_ton_variable)
    for j=1:length(velocity_cruise_vehicle_kmh_variable)
        Fvf_matrix(j,i)=((0.34.*(Moew_ton_variable(i).^1.75))+(7.06.*(velocity_cruise_vehicle_kmh_variable(j).^0.4)));    
    end 
end
%{
Database_x = [2, 3, 5, 6, 20];
Database_y = [66000, 79200, 170000, 6605, 133250];

for i=1:length(Database_y)
    
        Hva_matrix_database(i) =(1746*(Database_y(i).^0.284)*f1*f3).*(Database_x(i).^0.15);     %airframe (with subsystems), or vehicle without engines
        
   
end
%}
figure(4)
surf(Moew_ton_variable,velocity_cruise_vehicle_kmh_variable,Fvf_matrix)
xlabel({'Operating empty weight M_O_E_W','[tons]'})
ylabel({'Cruise speed','[Km/h]'})
zlabel({'F_V_F PROD Vehicle w/o engines cost ','[MYr]'})
hold on
%{
Database_name =["Concorde", "XB-70", "LAPCAT A2", "X-15", "SpaceLiner Orbiter"];
for kont=1:length(Database_x)
    plot3(Database_x(kont),Database_y(kont),Hva_matrix_database(kont),'.','MarkerSize',30,'DisplayName',Database_name(kont))
    hold on
end
%}    
colormap turbo
colorbar
grid on
f = figure(4);  
f.Position = [100 100 900 675]; 


%% PROD RESEARCH V2 %MYr %System Level - Propulsion system

                                                    %Production (PROD) cost for turbojet engine [WYr]

%Fet_originalTRANSCOST = (2.29*(M_engineATR_dry^0.545))*f4*n

%Fet_PROD = ((2.29*(M_engineATR_dry^0.53))+(0.5*(velocity_cruise_engine^0.6)))*f4_n;

M_engineATR_dry_variable = 200:200:12000;
velocity_cruise_engine_variable = 40:40:2000;


velocity_cruise_engine_1 = [100, 200, 300, 500, 800, 1000, 1250, 1500, 2000];

figure(5)
for k=1:length(velocity_cruise_engine_1)
    Fet_massengine_variable = ((2.29.*(M_engineATR_dry_variable.^0.53))+(0.5.*(velocity_cruise_engine_1(k).^0.6)));
    txt = ['v = ',num2str(velocity_cruise_engine_1(k)),' [m/s]'];
    plot(M_engineATR_dry_variable,Fet_massengine_variable,'DisplayName',txt)
    hold on
end
xlabel({'ATR engine dry Mass','[kg]'})
ylabel({'F_E_T PROD ATR Engine Cost','[MYr]'})
legend show
grid on
f = figure(5);  
f.Position = [100 100 800 600]; 


M_engineATR_dry_1 = [1000, 2000, 3000, 5000, 7500, 10000];

figure(6)
for k=1:length(M_engineATR_dry_1)
    Fet_velocity_cruise_engine_variable = ((2.29.*(M_engineATR_dry_1(k).^0.53))+(0.5.*(velocity_cruise_engine_variable.^0.6)));
    txt = ['ATR engine dry Mass = ',num2str(M_engineATR_dry_1(k)),' [kg]'];
    plot(velocity_cruise_engine_variable,Fet_velocity_cruise_engine_variable,'DisplayName',txt)
    hold on
end
xlabel({'Maximum engine speed','[m/s]'})
ylabel({'F_E_T PROD ATR Engine Cost','[MYr]'})
legend show
grid on
f = figure(6);  
f.Position = [100 100 800 600];


i=0:1:length(velocity_cruise_engine_variable);
j=0:1:length(M_engineATR_dry_variable);
for i=1:length(velocity_cruise_engine_variable)
    for j=1:length(M_engineATR_dry_variable)
        Fet_matrix(i,j) = ((2.29.*(M_engineATR_dry_variable(j).^0.53))+(0.5.*(velocity_cruise_engine_variable(i).^0.6)));
    end 
end

figure(7)
surf(M_engineATR_dry_variable,velocity_cruise_engine_variable,Fet_matrix)
ylabel({'Maximum engine speed','[m/s]'})
xlabel({'ATR engine dry Mass','[kg]'})
zlabel({'F_E_T PROD ATR Engine Cost','[MYr]'})
hold on
colormap turbo
colorbar
grid on
f = figure(7);  
f.Position = [100 100 900 675];


                                                         %Production cost for ramjet engine [WYr]

%Fer_PROD = (5.63*(ThrustDMR^0.35))*f4_n;

ThrustDMR_variable = 0:10:10000;
Fer_ThrustDMR_variable=(5.63.*(ThrustDMR_variable.^0.35));

figure(8)
plot(ThrustDMR_variable,Fer_ThrustDMR_variable)
axis tight
xlabel({'DMR engine dry Mass','[kg]'})
ylabel({'F_E_R PROD DMR Engine Cost','[MYr]'})
grid on
f = figure(8);  
f.Position = [100 100 800 600];


                                                    %Production cost for Combined Cycle Engine [WYr]

%Fcce_PROD = C_complex.*(Ktj.*Fet_PROD+Krj.*Fer_PROD)*f4_n;

                                                                %Total Production cost [WYr]_[M$]

%Cost_TOT_PROD = ((f0^n_stage)*(Fvf_PROD + Fer_PROD + Fcce_PROD)*f8)*MYr_to_Milion_factor*(CPI_2023/CPI_2016);

%% PROD RESEARCH V2 %MYr % Subsystem Level __FUEL SYSTEM

%Transcost

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 70.9;                %fuel density [kg/m3]

Moew_variable = 0:5000:200000;
M_engine_dry_variable = 0:625:25000;

                                                            %PROD cost for fuel system [WYr]

%S_fuel_PROD = ((0.48.*(Moew.^0.38))+(0.5.*(M_engine_dry.^0.39)))*f4_n;

M_engine_dry_1 = [1000, 2500, 5000, 10000, 20000, 30000, 40000, 50000];
figure(9)
for k=1:length(M_engine_dry_1)
    S_fuel_PROD_Moew_variable = ((0.48.*(Moew_variable.^0.38))+(0.5.*(M_engine_dry_1(k).^0.39)));
    txt = ['Engine dry Mass = ',num2str(M_engine_dry_1(k)),' [kg]'];
    plot(Moew_variable,S_fuel_PROD_Moew_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Fuel system PROD Cost','[MYr]'})
legend show
grid on
f = figure(9);  
f.Position = [100 100 800 600];

Moew_1 = [50000, 100000, 120000, 150000, 180000, 200000];
figure(10)
for k=1:length(Moew_1)
    S_fuel_PROD_M_engine_dry_variable = ((0.48.*(Moew_1(k).^0.38))+(0.5.*(M_engine_dry_variable.^0.39)));
    txt = ['M_O_E_W = ',num2str(Moew_1(k)),' [kg]'];
    plot(M_engine_dry_variable,S_fuel_PROD_M_engine_dry_variable,'DisplayName',txt)
    hold on
end
xlabel({'Engine dry Mass','[kg]'})
ylabel({'Fuel system PROD Cost','[MYr]'})
legend show
grid on
f = figure(10);  
f.Position = [100 100 800 600];

i=0:1:length(M_engine_dry_variable);
j=0:1:length(Moew_variable);
for i=1:length(M_engine_dry_variable)
    for j=1:length(Moew_variable)
        S_fuel_PROD_matrix(i,j) = ((0.48.*(Moew_variable(j).^0.38))+(0.5.*(M_engine_dry_variable(i).^0.39)));
    end 
end

figure(11)
surf(Moew_variable,M_engine_dry_variable,S_fuel_PROD_matrix)
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Engine dry weight','[kg]'})
zlabel({'Fuel system PROD Cost','[MYr]'})

colormap turbo
colorbar
grid on
f = figure(11);  
f.Position = [100 100 900 675];


%% PROD RESEARCH V2 %MYr % Subsystem Level __TPS SYSTEM

%Transcost

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 70.74;                %fuel density [kg/m^3]
Q = 10000;                      %heat load in [J/m^2]

Moew_variable = [500, 5000:5000:200000];
%q_variable = 0:14000:7000000;
Q_variable = [87500000, 875000000:875000000:35000000000];

cruise_duration_inSeconds = 10800;

                                                        %PROD cost for TPS system [WYr]

%S_TPS_PROD = ((0.51.*(Moew.^0.19))+(3.41.*(q.^0.12))+(0.68.*(Q.^0.11)))*f4_n;


%heat flux [W/m^2] = heat load [J/m^2] / time(second)

Q_1 = [1e6, 9*1e6, 5*1e7, 1e8, 1e9, 1e10, 2*1e10, 3*1e10];
q_1 = Q_1./cruise_duration_inSeconds;
q_11 = [200000, 1000000, 7000000];

figure(12)
for k=1:length(Q_1)
    S_TPS_PROD_Moew_variable = ((0.51.*(Moew_variable.^0.19))+(3.41.*(q_11(3).^0.12))+(0.68.*(Q_1(k).^0.11)));
    txt = ['Heat Load = ',num2str(Q_1(k)),' [J/m^2]'];
    plot(Moew_variable,S_TPS_PROD_Moew_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'TPS system PROD Cost','[MYr]'})
legend show
format short e
grid on
f = figure(12);  
f.Position = [100 100 800 600];

Moew_1 = [50000, 100000, 120000, 150000, 180000, 200000];
figure(13)
for k=1:length(Moew_1)
    S_TPS_PROD_Q_variable = ((0.51.*(Moew_1(k).^0.19))+(3.41.*(q_11(3).^0.12))+(0.68.*(Q_variable.^0.11)));
    txt = ['M_O_E_W = ',num2str(Moew_1(k)),' [kg]'];
    plot(Q_variable,S_TPS_PROD_Q_variable,'DisplayName',txt)
    hold on
end
xlabel({'Heat Load','[J/m^2]'})
ylabel({'TPS system PROD Cost','[MYr]'})
legend show
grid on
f = figure(13);  
f.Position = [100 100 800 600];



figure(14)
i=0:1:length(Q_variable);
j=0:1:length(Moew_variable);
for k=1:length(q_11)
    for i=1:length(Q_variable)
        for j=1:length(Moew_variable)
            S_TPS_PROD_matrix(i,j) = ((0.51.*(Moew_variable(j).^0.19))+(3.41.*(q_11(k).^0.12))+(0.68.*(Q_variable(i).^0.11)));
        end 
    end
    surf(Moew_variable,Q_variable,S_TPS_PROD_matrix,'FaceAlpha',0.75)
    hold on 
end 

xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Heat Load','[J/m^2]'})
zlabel({'TPS system PROD Cost','[MYr]'})
colormap turbo
colorbar
grid on
f = figure(14);  
f.Position = [100 100 900 675];

%% PROD RESEARCH V2 %MYr % Subsystem Level __TEMS SYSTEM

%Transcost

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 70.9;                 %fuel density [kg/m3]

Moew_variable = 5000:5000:200000;
P_variable = 20000:20000:1000000;

                                                                %PROD cost for TEMS [WYr]

%S_TEMS_PROD= ((5.41*(Moew^0.23))+(0.79*(P^0.15))+(0.52*(mpunto_bo_LH2^0.19)))*f4_n;


P_1 = [10000, 50000, 100000, 250000, 500000, 1000000];
figure(15)
for k=1:length(P_1)
    S_TEMS_PROD_P_variable= ((5.41.*(Moew_variable.^0.23))+(0.79.*(P_1(k).^0.15))+(0.52*(mpunto_bo_LH2^0.19)));
    txt = ['Power produced by TEMS = ',num2str(P_1(k)),' [W]'];
    plot(Moew_variable,S_TEMS_PROD_P_variable,'DisplayName',txt)
    hold on
end
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'TEMS system PROD Cost','[MYr]'})
legend show
grid on
f = figure(15);  
f.Position = [100 100 800 600];


Moew_1 = [50000, 100000, 120000, 150000, 180000, 200000];
figure(16)
for k=1:length(Moew_1)
    S_TEMS_PROD_P_variable= ((5.41.*(Moew_1(k).^0.23))+(0.79.*(P_variable.^0.15))+(0.52*(mpunto_bo_LH2^0.19)));
    txt = ['M_O_E_W = ',num2str(Moew_1(k)),' [kg]'];
    plot(P_variable,S_TEMS_PROD_P_variable,'DisplayName',txt)
    hold on
end
xlabel({'Power produced by TEMS','[W]'})
ylabel({'TEMS system PROD Cost','[MYr]'})
legend show
grid on
f = figure(16);  
f.Position = [100 100 800 600];

i=0:1:length(P_variable);
j=0:1:length(Moew_variable);
for i=1:length(P_variable)
    for j=1:length(Moew_variable)
        S_TEMS_PROD_matrix(i,j)= ((5.41.*(Moew_variable(j).^0.23))+(0.79.*(P_variable(i).^0.15))+(0.52*(mpunto_bo_LH2^0.19)));
    end 
end


figure(17)
surf(Moew_variable,P_variable,S_TEMS_PROD_matrix)
xlabel({'Operating empty weight M_O_E_W','[kg]'})
ylabel({'Power produced by TEMS','[W]'})
zlabel({'TEMS system PROD Cost','[MYr]'})

colormap turbo
colorbar
grid on
f = figure(17);  
f.Position = [100 100 900 675];

%% RDTE RESEARCH V2 %MYr % Subsystem Level __OTHER SUBSYSTEM

%{ 
COSTO PROD TOT - (COSTO PROPULSION SYSTEM + COSTO FUEL SYSTEM + COSTO TPS SYSTEM + COSTO TEMS SYSTEM )

OPPURE COSTO PROD VEHICLE W/O ENGINE - (COSTO FUEL SYSTEM + COSTO TPS SYSTEM + COSTO TEMS SYSTEM)

A QUESTA RIMANENZA SCALARE LE PERCENTUALI




%}









